----------------------------------------------------------------------
--  Dictionary.Scanner - Package specification                      --
--  Copyright (C) 2002 Adalog                                       --
--  Author: J-P. Rosen                                              --
--                                                                  --
--  ADALOG   is   providing   training,   consultancy,   expertise, --
--  assistance and custom developments  in Ada and related software --
--  engineering techniques.  For more info about our services:      --
--  ADALOG                   Tel: +33 1 41 24 31 40                 --
--  19-21 rue du 8 mai 1945  Fax: +33 1 41 24 07 36                 --
--  94110 ARCUEIL            E-m: info@adalog.fr                    --
--  FRANCE                   URL: http://www.adalog.fr              --
--                                                                  --
--  This  unit is  free software;  you can  redistribute  it and/or --
--  modify  it under  terms of  the GNU  General Public  License as --
--  published by the Free Software Foundation; either version 2, or --
--  (at your  option) any later version.  This  unit is distributed --
--  in the hope  that it will be useful,  but WITHOUT ANY WARRANTY; --
--  without even the implied warranty of MERCHANTABILITY or FITNESS --
--  FOR A  PARTICULAR PURPOSE.  See the GNU  General Public License --
--  for more details.   You should have received a  copy of the GNU --
--  General Public License distributed  with this program; see file --
--  COPYING.   If not, write  to the  Free Software  Foundation, 59 --
--  Temple Place - Suite 330, Boston, MA 02111-1307, USA.           --
--                                                                  --
--  As  a special  exception, if  other files  instantiate generics --
--  from  this unit,  or you  link this  unit with  other  files to --
--  produce an executable,  this unit does not by  itself cause the --
--  resulting executable  to be covered  by the GNU  General Public --
--  License.  This exception does  not however invalidate any other --
--  reasons why  the executable  file might be  covered by  the GNU --
--  Public License.                                                 --
----------------------------------------------------------------------

package Dictionary.Scanner is
   -- Scans from current input
   Max_ID_Length : constant := 250;

   type Token_Kind is (Name, Keyword,
                       Arrow, Left_Bracket, Right_Bracket, Semi_Colon, Comma, Period,
                       EoL, EoF);   --## RULE LINE OFF Naming_Convention

   --Tokens made of a single character
   subtype Character_Token_Kind is Token_Kind range Left_Bracket .. Period;

   type Key_Kind   is (Key_Abs, Key_Access, Key_All, Key_In, Key_Not, Key_Return);

   type Token (Kind : Token_Kind := EoL) is
      record
         case Kind is
            when Name =>
               Length : Positive;
               Text   : Wide_String (1..Max_ID_Length);
            when Keyword =>
               Key : Key_Kind;
            when others =>
               null;
         end case;
      end record;

   procedure Start_Scan (Substitution_String : Wide_String := "");

   function Current_Token return Token;
   function Current_Name return Wide_String;

   procedure Next_Token;
   -- Advance to next token;

   procedure Syntax_Error (Message : Wide_String);
   -- Prints message and raises User_Error
   pragma No_Return (Syntax_Error);

end Dictionary.Scanner;
