----------------------------------------------------------------------
--  Dictionary.Table_manager - Package specification                --
--  Copyright (C) 2002 Adalog                                       --
--  Author: J-P. Rosen                                              --
--                                                                  --
--  ADALOG   is   providing   training,   consultancy,   expertise, --
--  assistance and custom developments  in Ada and related software --
--  engineering techniques.  For more info about our services:      --
--  ADALOG                   Tel: +33 1 41 24 31 40                 --
--  19-21 rue du 8 mai 1945  Fax: +33 1 41 24 07 36                 --
--  94110 ARCUEIL            E-m: info@adalog.fr                    --
--  FRANCE                   URL: http://www.adalog.fr              --
--                                                                  --
--  This  unit is  free software;  you can  redistribute  it and/or --
--  modify  it under  terms of  the GNU  General Public  License as --
--  published by the Free Software Foundation; either version 2, or --
--  (at your  option) any later version.  This  unit is distributed --
--  in the hope  that it will be useful,  but WITHOUT ANY WARRANTY; --
--  without even the implied warranty of MERCHANTABILITY or FITNESS --
--  FOR A  PARTICULAR PURPOSE.  See the GNU  General Public License --
--  for more details.   You should have received a  copy of the GNU --
--  General Public License distributed  with this program; see file --
--  COPYING.   If not, write  to the  Free Software  Foundation, 59 --
--  Temple Place - Suite 330, Boston, MA 02111-1307, USA.           --
--                                                                  --
--  As  a special  exception, if  other files  instantiate generics --
--  from  this unit,  or you  link this  unit with  other  files to --
--  produce an executable,  this unit does not by  itself cause the --
--  resulting executable  to be covered  by the GNU  General Public --
--  License.  This exception does  not however invalidate any other --
--  reasons why  the executable  file might be  covered by  the GNU --
--  Public License.                                                 --
----------------------------------------------------------------------

private package Dictionary.Table_Manager is
   type Table is limited private;

   Not_Present     : exception;
   Already_Present : exception;

   procedure Add (Key   : in Wide_String;
                  Value : in Dictionary_Data;
                  To    : in out Table);
   procedure Replace (Key   : in Wide_String;
                      Value : in Dictionary_Data;
                      Into  : in out Table);
   function  Fetch      (Key : Wide_String; From : Table) return Dictionary_Data;
   function  Is_Present (Key : Wide_String; Into : Table) return Boolean;

   type Dictionary_Data_Access is access all Dictionary_Data;
   function  Fetch (Key : Wide_String; From : Table) return Dictionary_Data_Access;
   -- Returns null without raising Not_Present if the Key is not in the table

   generic
      with procedure Action (Key : in Wide_String; Value : in out Dictionary_Data);
   procedure Iterate (Over : Table);

   procedure Balance (The_Table : in out Table);

private
   type Node;
   type Link is access Node;
   type Node (K_Length : Natural) is
      record
         Key   : Wide_String (1..K_Length);
         Value : Dictionary_Data_Access;
         Left  : Link;
         Right : Link;
      end record;

   -- Yet another example of the Rosen trick...
   type Autopointer (Accessor : access Table) is limited null record;
   type Table is limited
      record
         Myself       : Autopointer (Table'Access);
         Root         : Link;
         Last_Visited : Link;
      end record;
end Dictionary.Table_Manager;
