----------------------------------------------------------------------
--  Dictionary - Package specification                              --
--  Copyright (C) 2002 Adalog                                       --
--  Author: J-P. Rosen                                              --
--                                                                  --
--  ADALOG   is   providing   training,   consultancy,   expertise, --
--  assistance and custom developments  in Ada and related software --
--  engineering techniques.  For more info about our services:      --
--  ADALOG                   Tel: +33 1 41 24 31 40                 --
--  19-21 rue du 8 mai 1945  Fax: +33 1 41 24 07 36                 --
--  94110 ARCUEIL            E-m: info@adalog.fr                    --
--  FRANCE                   URL: http://www.adalog.fr              --
--                                                                  --
--  This  unit is  free software;  you can  redistribute  it and/or --
--  modify  it under  terms of  the GNU  General Public  License as --
--  published by the Free Software Foundation; either version 2, or --
--  (at your  option) any later version.  This  unit is distributed --
--  in the hope  that it will be useful,  but WITHOUT ANY WARRANTY; --
--  without even the implied warranty of MERCHANTABILITY or FITNESS --
--  FOR A  PARTICULAR PURPOSE.  See the GNU  General Public License --
--  for more details.   You should have received a  copy of the GNU --
--  General Public License distributed  with this program; see file --
--  COPYING.   If not, write  to the  Free Software  Foundation, 59 --
--  Temple Place - Suite 330, Boston, MA 02111-1307, USA.           --
--                                                                  --
--  As  a special  exception, if  other files  instantiate generics --
--  from  this unit,  or you  link this  unit with  other  files to --
--  produce an executable,  this unit does not by  itself cause the --
--  resulting executable  to be covered  by the GNU  General Public --
--  License.  This exception does  not however invalidate any other --
--  reasons why  the executable  file might be  covered by  the GNU --
--  Public License.                                                 --
----------------------------------------------------------------------

with Asis;
package Dictionary is
   Invalid_Dictionary  : exception;

   procedure Initialize (Dictionary_Name : String);

   type Multiplicity_Kind is (Single, Multiple);

   type Substitution_Kind is (Name, Short, Qualified);

   -- Returns the substitution for E, or raises Invalid_Substitution if there is none.
   --  Kind = Name      : Only the simple name
   --         Short     : Everything left of "in" if any, same as name otherwise
   --         Qualified : Fully qualified name (i.e. A.B.C)
   function Substitution (E            : Asis.Element;
                          Kind         : Substitution_Kind;
                          Multiplicity : Multiplicity_Kind := Single) return Wide_String;

   -- Check if there is a substitution.
   --   Kind = Name      : any substitution
   --          Short     : unused currently, same as name
   --          Qualified : the substitution includes prefixes
   function Has_Substitution (E : Asis.Element; Kind : Substitution_Kind := Name) return Boolean;

private
   -- These declarations here to be visible to Dictionary.Table_Manager
   type Substitution_Params (Name_Length, Location_Length : Natural) is
      record
         Name     : Wide_String (1..Name_Length);
         Location : Wide_String (1..Location_Length);
         Absolute : Boolean;
         Multiple : Boolean;
      end record;

   Null_Params : constant Substitution_Params := (Name_Length | Location_Length => 0,
                                                  Name        | Location        => "",
                                                  Absolute    | Multiple        => False);

   type Data_Substitution_Kind is (Present, None, Undefined);
   type Dictionary_Data (Name_Length, Location_Length : Natural) is
      record
         Substitution    : Data_Substitution_Kind;
         Has_Overloading : Boolean;
         Params          : Substitution_Params (Name_Length, Location_Length);
      end record;
end Dictionary;
