----------------------------------------------------------------------
--  Tools.Dependencies - Package body                               --
--  Copyright (C) 2002, 2007 Adalog                                 --
--  Author: J-P. Rosen                                              --
--                                                                  --
--  ADALOG   is   providing   training,   consultancy,   expertise, --
--  assistance and custom developments  in Ada and related software --
--  engineering techniques.  For more info about our services:      --
--  ADALOG                   Tel: +33 1 41 24 31 40                 --
--  19-21 rue du 8 mai 1945  Fax: +33 1 41 24 07 36                 --
--  94110 ARCUEIL            E-m: info@adalog.fr                    --
--  FRANCE                   URL: http://www.adalog.fr              --
--                                                                  --
--  This  unit is  free software;  you can  redistribute  it and/or --
--  modify  it under  terms of  the GNU  General Public  License as --
--  published by the Free Software Foundation; either version 2, or --
--  (at your  option) any later version.  This  unit is distributed --
--  in the hope  that it will be useful,  but WITHOUT ANY WARRANTY; --
--  without even the implied warranty of MERCHANTABILITY or FITNESS --
--  FOR A  PARTICULAR PURPOSE.  See the GNU  General Public License --
--  for more details.   You should have received a  copy of the GNU --
--  General Public License distributed  with this program; see file --
--  COPYING.   If not, write  to the  Free Software  Foundation, 59 --
--  Temple Place - Suite 330, Boston, MA 02111-1307, USA.           --
--                                                                  --
--  As  a special  exception, if  other files  instantiate generics --
--  from  this unit,  or you  link this  unit with  other  files to --
--  produce an executable,  this unit does not by  itself cause the --
--  resulting executable  to be covered  by the GNU  General Public --
--  License.  This exception does  not however invalidate any other --
--  reasons why  the executable  file might be  covered by  the GNU --
--  Public License.                                                 --
----------------------------------------------------------------------

with   -- Standard Ada units
  Ada.Characters.Handling,
  Ada.Command_Line,
  Ada.Wide_Text_IO;

with   -- Application specific units
  Utilities;

package body Tools.Dependencies is

   -------------
   -- Process --
   -------------

   procedure Process (Unit_Name        : in Wide_String;
                      Output_Name      : in String;
                      Overwrite_Option : in Boolean)
   is
      use Ada.Command_Line, Ada.Characters.Handling, Ada.Wide_Text_IO, Utilities;
      F_Out : File_Type;
   begin

      --
      -- Initialize environment
      --
      if Output_Name /= "" then
         Safe_Open (F_Out, Name => Output_Name, Mode => Append, Overwrite_Option => Overwrite_Option);
         Set_Output (F_Out);
      end if;

      if Overwrite_Option then
         Put ("-- Generated by command: ");
         Put (To_Wide_String (Command_Name));
         for A in Positive range 1 .. Argument_Count loop
            Put (' ');
            Put (To_Wide_String (Argument (A)));
         end loop;
         New_Line;
      end if;

      Put_Line (Unit_Name);

      if Is_Open (F_Out) then
         Set_Output (Standard_Output);
         Close (F_Out);
      end if;
   exception
      when others =>
         if Is_Open (F_Out) then
            Set_Output (Standard_Output);
            Close (F_Out);
         end if;
   end Process;

end Tools.Dependencies;
