----------------------------------------------------------------------
--  Tools.Translator.Processing - Package specification             --
--  Copyright (C) 2002, 2007 Adalog                                 --
--  Author: J-P. Rosen                                              --
--                                                                  --
--  ADALOG   is   providing   training,   consultancy,   expertise, --
--  assistance and custom developments  in Ada and related software --
--  engineering techniques.  For more info about our services:      --
--  ADALOG                   Tel: +33 1 41 24 31 40                 --
--  19-21 rue du 8 mai 1945  Fax: +33 1 41 24 07 36                 --
--  94110 ARCUEIL            E-m: info@adalog.fr                    --
--  FRANCE                   URL: http://www.adalog.fr              --
--                                                                  --
--  This  unit is  free software;  you can  redistribute  it and/or --
--  modify  it under  terms of  the GNU  General Public  License as --
--  published by the Free Software Foundation; either version 2, or --
--  (at your  option) any later version.  This  unit is distributed --
--  in the hope  that it will be useful,  but WITHOUT ANY WARRANTY; --
--  without even the implied warranty of MERCHANTABILITY or FITNESS --
--  FOR A  PARTICULAR PURPOSE.  See the GNU  General Public License --
--  for more details.   You should have received a  copy of the GNU --
--  General Public License distributed  with this program; see file --
--  COPYING.   If not, write  to the  Free Software  Foundation, 59 --
--  Temple Place - Suite 330, Boston, MA 02111-1307, USA.           --
--                                                                  --
--  As  a special  exception, if  other files  instantiate generics --
--  from  this unit,  or you  link this  unit with  other  files to --
--  produce an executable,  this unit does not by  itself cause the --
--  resulting executable  to be covered  by the GNU  General Public --
--  License.  This exception does  not however invalidate any other --
--  reasons why  the executable  file might be  covered by  the GNU --
--  Public License.                                                 --
----------------------------------------------------------------------
private package Tools.Translator.Processing is
   use Asis;

   --
   -- Pre-procedure processing:
   --

   -- Process names and similar elements (Enumeration_Litteral, Operator_Symbol)
   -- Element can be a long name (i.e. a Selected_Component)
   -- We chose to not separate the processing of long names from short names because:
   --   - There is a lot in common
   --   - Having the priorities of substitutions right for a long name requires
   --     accessing the possible substitutions of the corresponding short name.
   procedure Process_Name (Element   : in     Asis.Element;
                           Control   : in out Asis.Traverse_Control;
                           State     : in out Info);

   -- Process unary and binary infix operations, including those that are not
   -- operators (and then, or else, in, not in).
   procedure Process_Infix_Operation (Left      : in     Asis.Element;
                                      Operation : in     Asis.Element;
                                      Right     : in     Asis.Element;
                                      Control   : in out Asis.Traverse_Control;
                                      State     : in out Info);


   --
   -- Post-procedure processing:
   --

   -- Handle named elements whose name is repeated at the end, if the name is
   -- subject to substitution.
   procedure Process_Named_Element (The_Element : Element;
                                    The_Name    : Defining_Name);
end Tools.Translator.Processing;
