procedure T_Instantiate_Nesting is
   generic
      Tag : String;
   package Inner_Gen is
      V : constant String := Tag;
      procedure Force_Body;
   end Inner_Gen;
   package body Inner_Gen is
      procedure Force_Body is begin null; end;
   end Inner_Gen;

   generic
   package Outer_Gen1 is
      package Nested_11 is new Inner_Gen ("Nested 11");
      package Nested_12 is new Inner_Gen ("Nested 12");
   end Outer_Gen1;
   package body Outer_Gen1 is
   end Outer_Gen1;

   generic
   package Outer_Gen2 is
      package Nested_21 is new Inner_Gen ("Nested 21");
      package Nested_22 is new Inner_Gen ("Nested 22");
   end Outer_Gen2;

   -----------------------------------------------------------------------

   package Outer_Inst1 is new Outer_Gen1;

   -----------------------------------------------------------------------

   package Outer_Inst2 is new Outer_Gen2;

   -----------------------------------------------------------------------


   package Outer_Outer1 is
      package Outer_Inst2 is new Outer_Gen1;
      package Outer_Inst3 is new Outer_Gen1;
   end Outer_Outer1;

   -----------------------------------------------------------------------

   package Outer_Outer2 is
      package Outer_Inst21 is new Outer_Gen1;
      package Outer_Inst22 is new Outer_Gen2;
   end Outer_Outer2;

   package body Outer_Outer2 is
   end Outer_Outer2;

   -----------------------------------------------------------------------

   package Nest1 is
      package Nest2 is
         package Nest3 is
            package Nested_3 is new Inner_Gen ("Nested 3");
         end Nest3;
         package Nest4 is
            package Nested_4 is new Inner_Gen ("Nested 4");
            package Nested_5 is new Inner_Gen ("Nested 5");
         end Nest4;
         package Nested_6 is new Inner_Gen ("Nested 6");
      end Nest2;
   end Nest1;

begin
   declare
      package Outer_Outer3 is
         package Outer_Inst31 is new Outer_Gen1;
         package Outer_Inst32 is new Outer_Gen2;
      end Outer_Outer3;
   begin
      null;
   end;
end T_Instantiate_Nesting;
