with Ada.Strings.Unbounded;
with X_Unuse_Pack;
use type X_Unuse_Pack.Pack_Int2;
procedure T_Unuse is
   use Ada, Ada.Strings, Ada.Strings.Unbounded;

   -- Various namings
   S1 : Unbounded_String;
   S2 : Unbounded.Unbounded_String;
   S3 : Strings.Unbounded.Unbounded_String;

   I1 : aliased X_Unuse_Pack.Pack_Int1;
   I2 : X_Unuse_Pack.Pack_Int2;

   Enum : X_Unuse_Pack.Pack_Enum;

   -- Pragmas and attributes
   type Tab is array (1 .. 10) of Character;
   pragma Pack (Tab);
   for Tab'Size use 80;

   -- Don't apply to entities from Standard
   I_Standard : Integer := 3;
   Direct_Vis : String := Integer'Image (I_Standard);

   package Not_Direct_Vis is
      Internal_S : String := Integer'Image (I_Standard);
   end Not_Direct_Vis;
   use Not_Direct_Vis;

begin
   -- Various usages
   S1 := Null_Unbounded_String;
   I_Standard := I_Standard + 2;

   declare
      use X_Unuse_Pack;
      use Internal;
      D : Dispatcher'Class := F;
      ND : Dispatcher;
   begin
      Direct_Vis (V) := 'a';
      T_Unuse.Direct_Vis (Internal.V) := 'a';
      Internal_S (V) := 'a';
      Direct_Vis (V) := 'a';
      I1 := I1 - 1;
      I2 := I2 + 1;
      Ptr.all := 3;
      X_Unuse_Pack.Ptr.all := 4;

      Enum := A;
      Enum := A + B;
      Enum := "+" (X_Unuse_Pack.A, B);

      ND := Dispatcher (F);
      Prim1 (D);
      Prim1 (ND);
   end;

   declare
      use  X_Unuse_Pack;
      use all type X_Unuse_Pack.Pack_Enum, X_Unuse_Pack.Dispatcher;
      use all type Pack_Int1;
      D : Dispatcher'Class := F;
      ND : Dispatcher;
   begin
      Enum := A + B;
      Enum := "+" (X_Unuse_Pack.A, B);
      I1 := I1 - 1;
      I2 := I2 + 1;
      Ptr.all := 3;
      X_Unuse_Pack.Ptr.all := 4;

      ND := Dispatcher (F);
      Prim1 (D);
      Prim1 (ND);
   end;

   declare
      use  X_Unuse_Pack;
      use type X_Unuse_Pack.Pack_Enum, X_Unuse_Pack.Dispatcher;
      use type Pack_Int1;
      D : Dispatcher'Class := F;
      ND : Dispatcher;
   begin
      Enum := A + B;
      Enum := "+" (X_Unuse_Pack.A, B);
      I1 := I1 - 1;
      I2 := I2 + 1;
      Ptr.all := 3;
      X_Unuse_Pack.Ptr.all := 4;

      ND := Dispatcher (F);
      Prim1 (D);
      Prim1 (ND);
   end;

   -- Calls, dispatching calls and prefix notation
   declare
      use X_Unuse_Pack;
      VD : Dispatcher;
      VDC : Dispatcher'Class := F;
   begin
      Prim1 (VD);
      Prim1 (V => VD);
      VDC.Prim1;
      Prim1 (F);
      F.Prim1;
      Prim2 (F, G(VD));
      F.Prim2 (VD.G);
   end;
end T_Unuse;
